﻿WITH   RECURSIVE probleme_sudoku (enonce) AS (
VALUES ('5  3 8    235 48  4 1  6   8      4   6   2   7      5   4  3 6  96 345    2 7  1')),             
       chiffres AS (SELECT  generate_series chiffre FROM generate_series(1,9)),
       resolution_sudoku(solution, nb_case_vide) AS (
SELECT enonce,POSITION(' ' IN enonce) 
       -- Position dans la chaine de la sous-chaine
FROM   probleme_sudoku 
UNION  ALL
SELECT SUBSTR(solution,1,nb_case_vide-1)||CAST(chiffre AS TEXT)||SUBSTR(solution,nb_case_vide+1),
        -- Complète la grille avec le chiffre trouvé
        CASE POSITION( ' ' IN SUBSTR(solution,nb_case_vide+1)) 
             WHEN 0 THEN 0 
             ELSE POSITION(' ' IN SUBSTR(solution,nb_case_vide+1))+nb_case_vide END
 FROM   resolution_sudoku CROSS JOIN chiffres chiffres_sup
 WHERE  nb_case_vide > 0
 AND    NOT EXISTS 
        (SELECT NULL FROM chiffres
         WHERE  CAST(chiffres_sup.chiffre AS TEXT)=
                SUBSTR(solution,CAST(TRUNC((nb_case_vide-1)/9)AS INTEGER)
                       *9+chiffres.chiffre,1)
         -- Pas de chiffre identique dans la ligne de la case vide
         OR     CAST(chiffres_sup.chiffre AS TEXT)=
                SUBSTR(solution,MOD(nb_case_vide-1,9)-8+chiffres.chiffre*9,1)
         -- Pas de chiffre identique dans la colonne de la case vide
         OR     CAST(chiffres_sup.chiffre AS TEXT)=
                SUBSTR(solution,MOD(CAST(TRUNC((nb_case_vide-1)/3) AS INTEGER),3)*3
                + CAST(TRUNC((nb_case_vide-1)/27)AS INTEGER)*27+chiffres.chiffre
                + CAST(TRUNC((chiffres.chiffre-1)/3)AS INTEGER)*6,1)))
         -- Pas de chiffre identique dans le carré 3x3 de la case vide
SELECT  resolution_sudoku.solution
FROM  probleme_sudoku CROSS JOIN resolution_sudoku WHERE  nb_case_vide=0;
